// Animate.js by Radnen | 2008

/*
	GetDirectionNum() was sorta stolen from spherical when tunginobi made
	this example for getting the direction number in a spriteset. I figure
	this is the only way of doing so without adjusting loops or variable names...
*/
function GetDirectionNum(ss,direction)
{
	for (var i = 0; i < ss.directions.length; ++i)
	{
		if (ss.directions[i].name == direction) return i;
	}
	throw "could not find direction: " + direction + "in entity."; 
}

/*
	Animate function. It has a conditional for blocking events. This can
	be used for battle or in a cinematic when a certain animation needs playing.
*/
function Animate(person, direction)
{
	QueuePersonScript(person, 'SetPersonDirection("' + person + '", "' + direction + '")', false);
	QueuePersonScript(person, 'SetPersonFrame("' + person + '", 0)', false);
	const SS = GetPersonSpriteset(person);
	const D = SS.directions[GetDirectionNum(SS, direction)];
	const FRAMES = D.frames.length-1;
	const DELAY = D.frames[0].delay;
	for (var frame = 0; frame < FRAMES; ++frame)
	{
		for (var delay = 0; delay < DELAY; ++delay)
		{
			QueuePersonCommand(person, COMMAND_ANIMATE, false);
		}
	}
}


/*
	CreateEntityAnimation() is used to create a person that runs
	through an animate cycle and destroys itself when done. 
*/
function CreateEntityAnimation(name, spriteset, x, y, direction, layer)
{
	CreatePerson(name, spriteset, true);
	SetPersonXYFloat(name, x, y);
	SetPersonLayer(name, layer);
	AnimateDestroy(name, direction);
	UpdateMapEngine();
}

/*
	Will animate the entity and destroy it on animation end.
*/
function AnimateDestroy(person, direction)
{
	Animate(person, direction);
	SetPersonScript(person, SCRIPT_COMMAND_GENERATOR, 'WaitUntilClear()');
}

function WaitUntilClear()
{
	if (IsCommandQueueEmpty(GetCurrentPerson())) DestroyPerson(GetCurrentPerson());
}